# Fabrication: PCBWay

The basic usage of this exporter is:
```
kikit fab pcbway [OPTIONS] BOARD OUTPUTDIR
```

When you run this command, you will find file `gerbers.zip` in `OUTPUTDIR`. This
file can be directly uploaded to the PCBWay site. KiKit automatically detects
the number of layers.

If you want to name your files differently, you can specify `--nametemplate`.
For detailed description of this option, see [JLC PCB documentation](jlcpcb.md).

## Assembly

If you would also like to use the SMD assembly service, you have to specify
`--assembly` option and also provide the board `--schematic <schematics_file>`.
KiKit will generate two extra files: `bom.csv` (bill of materials) and `pos.csv`
(component placement). Use these two files when ordering the PCB assembly.

The files above will include all components on the board by default, except
footprints having the attribute virtual set. You should provide the
"Manufacturer" and "PartNumber" Fields for each component, where PartNumber
refers to the manufacturers part number (and can safely contain non-digit
characters). If the "Description" field is present, this value will be inserted
in the "Value/Description" column in the BOM, otherwise the value of the
component. It is recommended to provide no description for capacitors,
resistors, and inductors, so that the value is inserted into the BOM for them.
PCBWay also requires the soldering type (SMD, thru-hole, ...) to be specified.
Any footprint only having SMD pads will be considered as "SMD", everything else
as "thru-hole". You can manually overwrite the type by adding a "Type" field to
the component. For the footprint column of the BOM the KiCad footprint name is
used by default. Add a "FootprintPCBWay" field to overwrite this in the BOM list
for a more human readable footprint name, if you want. Finally, notes or
assembly instructions can be added using the "Notes" field.

You can exclude some of the components by specifying `--ignore <comma separated
list of references>`. When you pass option `--missingError`, KiKit will fail
when there is a component with missing manufacturer and/or part number. This
might be useful in case when you run KiKit in CI and you want to fail the build.

Note that when you order assembly for a panel, you should specify panelized
board and the original schematics of a single board. Use the `--nBoards`
parameter to specify the number of boards in the panel. The quantity column
is generated by multiplying this number with the number of references in
each row.

## Correction of the Footprint Position

It is possible that orientation footprints in your SMD does not match the
orientation of the components in the SMD assembly service. There are two
solutions:

- correct the orientation in the library or
- apply KiKit's orientation corrections.

The first option is not always feasible - e.g., when you use KiCAD's built-in
libraries or you are preparing a board for multiple fabrication houses and each
of them uses a different orientation.

KiKit allows you to specify the origin and orientation correction of the
position. The correction is specified by `PCBWAY_CORRECTION` field. The field
value is a semicolon separated tuple: `<X>; <Y>; <Rotation>` with values in
millimeters and degrees. You can read the XY corrections by hovering cursor over
the intended origin in footprint editor and mark the coordinates. Note that
first the rotation correction is applied, then the translation. Usually, you
will need only the rotation correction.

## Using Corrections to Configure Jumpers

If your board features solder jumpers you can use the corrections to specify
their default value. The solder jumper should be designed such it can fit a zero
Ohm resistor in suitable size. Then specify an order code of the zero Ohm
resistor for the jumper and adjust correction so it fits the default position.

Note that you can specify multiple correction fields by `--corrections <comma
separated list of correction filed names>`. The first found correction field is
used. This allows you to keep several configuration of the solder jumpers in
your design e.g., in fields `PCBWAY_CORRECTION_CFG_1` and
`PCBWAY_CORRECTION_CFG_2`. Then you can simply change the board configuration by
calling kikit with `--corrections PCBWAY_CORRECTION_CFG_1,PCBWAY_CORRECTION` or
`--corrections PCBWAY_CORRECTION_CFG_2,PCBWAY_CORRECTION`.
